<?php
// সরাসরি অ্যাক্সেস প্রতিরোধ করতে
if(!defined('BASEPATH')) {
   die('Direct access to the script is not allowed');
}

session_start();

// প্রতিদিনের সাবমিশনের লিমিট
$dailyLimit = 5;

// যদি সেশন ফিডব্যাক সাবমিশন সেট না থাকে, তাহলে সেট করা হচ্ছে
if(!isset($_SESSION['feedback_submissions'])) {
    $_SESSION['feedback_submissions'] = 0;
}

// বাকি সাবমিশনের সংখ্যা বের করা হচ্ছে
$remainingSubmissions = $dailyLimit - $_SESSION['feedback_submissions'];
$remainingSubmissions = max(0, $remainingSubmissions);

// POST রিকুয়েস্ট চেক করা হচ্ছে
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // যদি ডেইলি লিমিট পূর্ণ হয়ে থাকে
    if ($_SESSION['feedback_submissions'] >= $dailyLimit) {
        $errorMessage = "You have reached the daily limit for feedback submissions.";
    } else {
        // ইনপুট থেকে ডাটা স্যানিটাইজ করা
        $title = htmlspecialchars($_POST["title"]);
        $type = htmlspecialchars($_POST["type"]);
        $messageContent = htmlspecialchars($_POST["message"]);

        // ডাটাবেস থেকে অ্যাডমিন তথ্য বের করা হচ্ছে
        $tme = $conn->prepare("SELECT * FROM admins");
        $tme->execute(array());
        $the = $tme->fetch(PDO::FETCH_ASSOC);
        $username = $the["username"];

        // সার্ভার হোস্ট বের করা
        $panel = $_SERVER['HTTP_HOST'];

        // টেলিগ্রামে মেসেজ পাঠানোর জন্য ডাটা তৈরি করা
        $telegramBotToken = '7448895099:AAH8C5EKLR0GteBYtMUFiuAU27nCx7_-AII'; // আপনার বট টোকেন
        $telegramChatId = '6326853456'; // আপনার চ্যাট আইডি

        // টেলিগ্রামে পাঠানোর মেসেজ ফরম্যাট করা হচ্ছে
        $message = "<b>Feedback from:</b> <b>$panel</b>\n";
        $message .= "<b>Admin username is:</b> <b>$username</b>\n";
        $message .= "<b>Title:</b> $title\n";
        $message .= "<b>Feedback type:</b> $type\n";
        $message .= "<b>Message:</b> $messageContent";

        // টেলিগ্রামে মেসেজ পাঠানো
        $url = "https://api.telegram.org/bot$telegramBotToken/sendMessage";
        $data = [
            'chat_id' => $telegramChatId, // চ্যাট আইডি
            'text' => $message, // মেসেজের টেক্সট
            'parse_mode' => 'HTML' // HTML ফরম্যাটিং এনাবল করতে
        ];

        // cURL ব্যবহার করে মেসেজ পাঠানোর কোড
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        // রেসপন্স চেক করা
        if ($response) {
            $errorMessage = "Feedback successfully sent to the owner.";
        } else {
            $errorMessage = "Failed to send feedback. Please try again.";
        }

        // ফিডব্যাক সাবমিশন লিমিট আপডেট করা
        $_SESSION['feedback_submissions']++;
        $remainingSubmissions = $dailyLimit - $_SESSION['feedback_submissions'];
        $remainingSubmissions = max(0, $remainingSubmissions);
    }
}

// ভিউ লোড করা
require admin_view('feedback');
?>
